{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 06.09.98 - 14:22:32 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  MMSystem, MMRegs, MMUtils, MMObj, MMPCMSup, MMGauge, MMDSPObj, MMWave, StdCtrls, MMCstDlg;

type
  TForm1 = class(TForm)
    OpenDialog: TMMWaveOpenDialog;
    Button1: TButton;
    SrcFile: TMMWaveFile;
    DstFile: TMMWaveFile;
    SaveDialog: TSaveDialog;
    procedure Button1Click(Sender: TObject);
  private

  public
    procedure ConvertFile(SrcName,DstName: String; DstRate: integer);
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.ConvertFile(SrcName,DstName: String; DstRate: integer);
var
   dwSrc,dwDst: Longint;
   lpSrc,lpDst: PChar;
   wfx: TWaveFormatEx;
   nBytes,nRead,nWrite,nConvert: Longint;

begin
   { open the source file }
   SrcFile.Wave.FileName   := SrcName;
   SrcFile.Wave.TimeFormat := tfByte;
   SrcFile.Wave.OpenFile;

   { create a destination format }
   pcmBuildWaveHeader(@wfx,
                      SrcFile.PWaveFormat.wBitsPerSample,
                      SrcFile.PWaveFormat.nChannels,
                      DstRate);

   { create the destination file }
   DstFile.Wave.CreateFile(DstName,@wfx);

   { we use a 4096 byte buffer as source }
   dwSrc := 4096;
   { now calc the required output buffer size }
   dwDst := pcmConvertSizeOutputData(@wfx, Pointer(SrcFile.PWaveFormat), dwSrc)+4;

   { allocate memory }
   GetMem(lpSrc,dwSrc);
   GetMem(lpDst, dwDst);

   { get the total bytes }
   nBytes := SrcFile.Wave.Datasize;

   while (nBytes > 0) do
   begin
      nRead := dwSrc;
      if nBytes < nRead then nRead := nBytes;

      { read data }
      nRead := SrcFile.Wave.ReadDataBytes(lpSrc,nRead);
      if nRead <= 0 then break;

      { convert... }
      nConvert := pcmConvert(@wfx, lpDst,
                             Pointer(SrcFile.Wave.PWaveFormat),lpSrc,
                             nRead);
      if (nConvert <= 0) then break;


      { ...and write out }
      nWrite := DstFile.Wave.WriteDataBytes(lpDst,nConvert);
      if (nWrite <= 0) then break;

      dec(nBytes, nRead);
   end;

   { close the files }
   SrcFile.Wave.CloseFile;
   DstFile.Wave.CloseFile;

   { free memory }
   FreeMem(lpSrc);
   FreeMem(lpDst);
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
   if OpenDialog.Execute then
      if SaveDialog.Execute then
         ConvertFile(OpenDialog.FileName,SaveDialog.FileName,48000);
end;

end.
